<?php
// فایل bot.php - مدیریت وب‌هوک
require_once __DIR__ . '/vendor/autoload.php';
require_once __DIR__ . '/config.php';

use danog\MadelineProto\API;
use danog\MadelineProto\Logger;

// دریافت داده‌های JSON از ورودی تلگرام
$update = json_decode(file_get_contents('php://input'), true);

// اگر داده‌ای دریافت نشد، عملیاتی انجام نمی‌دهیم.
if (empty($update)) {
    return;
}

// استخراج chat_id از آپدیت
$chatId = $update['message']['chat']['id'] ?? $update['callback_query']['message']['chat']['id'] ?? null;
if (!$chatId) {
    return;
}

// مقداردهی اولیه MadelineProto برای ارسال پیام
$botAPI = new API(SESSIONS_DIR . 'bot.madeline', [
    'logger' => ['logger_level' => Logger::LOGGER_LEVEL_WARNING],
]);

try {
    $botAPI->async(function () use ($botAPI, $update, $chatId) {
        yield $botAPI->start();

        // مسیر فایل وضعیت کاربر
        $userStateFile = USERS_STATE_DIR . $chatId . '.json';
        $userState = file_exists($userStateFile) ? json_decode(file_get_contents($userStateFile), true) : ['step' => 'start'];

        $message = $update['message'] ?? null;
        $callbackQuery = $update['callback_query'] ?? null;

        // --- مدیریت دستورات ---
        if ($message && ($message['text'] ?? '') === '/start') {
            yield $botAPI->messages->sendMessage([
                'peer' => $chatId,
                'message' => 'به ربات سلف ساز خوش آمدید. برای شروع روی دکمه زیر کلیک کنید.',
                'reply_markup' => [
                    'inline_keyboard' => [
                        [[
                            'text' => 'ساخت سلف',
                            'callback_data' => 'create_self'
                        ]]
                    ]
                ]
            ]);
            $userState['step'] = 'waiting_for_command';
            file_put_contents($userStateFile, json_encode($userState));
        } elseif ($callbackQuery && $callbackQuery['data'] === 'create_self') {
            yield $botAPI->messages->sendMessage([
                'peer' => $chatId,
                'message' => 'لطفا شماره تلفن خود را با فرمت بین‌المللی (مثال: +989123456789) ارسال کنید:'
            ]);
            $userState['step'] = 'waiting_for_phone';
            file_put_contents($userStateFile, json_encode($userState));
        }

        // --- مدیریت مراحل احراز هویت ---
        if ($message && isset($userState['step'])) {
            $text = $message['text'] ?? '';
            
            switch ($userState['step']) {
                case 'waiting_for_phone':
                    $phone = $text;
                    if (preg_match('/^\+[0-9]{1,15}$/', $phone)) {
                        $madeline = new API(SESSIONS_DIR . $chatId . '.madeline');
                        try {
                            yield $madeline->start();
                            yield $madeline->phone_login($phone);
                            yield $botAPI->messages->sendMessage(['peer' => $chatId, 'message' => 'کد تایید را که از تلگرام دریافت کرده‌اید، ارسال کنید:']);
                            $userState['step'] = 'waiting_for_code';
                            $userState['phone'] = $phone;
                            file_put_contents($userStateFile, json_encode($userState));
                        } catch (\Throwable $e) {
                            yield $botAPI->messages->sendMessage(['peer' => $chatId, 'message' => 'خطا در ثبت شماره. لطفاً دوباره تلاش کنید: ' . $e->getMessage()]);
                            $userState['step'] = 'start';
                            file_put_contents($userStateFile, json_encode($userState));
                        }
                    } else {
                        yield $botAPI->messages->sendMessage(['peer' => $chatId, 'message' => 'فرمت شماره اشتباه است. لطفاً شماره را با فرمت بین‌المللی ارسال کنید:']);
                    }
                    break;

                case 'waiting_for_code':
                    $code = $text;
                    $madeline = new API(SESSIONS_DIR . $chatId . '.madeline');
                    try {
                        yield $madeline->start();
                        $authorization = yield $madeline->phone_complete_code($code);
                        if ($authorization['_'] === 'auth.authorization') {
                            yield $botAPI->messages->sendMessage(['peer' => $chatId, 'message' => 'احراز هویت با موفقیت انجام شد. از این پس می‌توانید از دستورات .time on و .time off در Saved Messages خود استفاده کنید.']);
                            $userState['step'] = 'authenticated';
                            $userState['time_on'] = false;
                            file_put_contents($userStateFile, json_encode($userState));
                        } else {
                            yield $botAPI->messages->sendMessage(['peer' => $chatId, 'message' => 'کد تایید اشتباه است. لطفاً مجدداً تلاش کنید.']);
                            $userState['step'] = 'waiting_for_code';
                            file_put_contents($userStateFile, json_encode($userState));
                        }
                    } catch (\Throwable $e) {
                        yield $botAPI->messages->sendMessage(['peer' => $chatId, 'message' => 'خطا در احراز هویت. لطفاً دوباره تلاش کنید: ' . $e->getMessage()]);
                        $userState['step'] = 'start';
                        file_put_contents($userStateFile, json_encode($userState));
                    }
                    break;
            }
        }
    });
} catch (\Throwable $e) {
    // در صورت بروز هرگونه خطای کلی، آن را به عنوان لاگ ثبت می‌کنیم.
    error_log("Error in bot.php: " . $e->getMessage());
}
