<?php
// فایل cron.php - اسکریپت کرون جاب
require_once __DIR__ . '/vendor/autoload.php';
require_once __DIR__ . '/config.php';

use danog\MadelineProto\API;
use danog\MadelineProto\Logger;

// تنظیم منطقه زمانی به وقت تهران
date_default_timezone_set('Asia/Tehran');

$sessions = glob(SESSIONS_DIR . '*.madeline.json');

foreach ($sessions as $sessionFile) {
    // استخراج user_id از نام فایل سشن
    $userId = basename($sessionFile, '.madeline.json');
    $userStateFile = USERS_STATE_DIR . $userId . '.json';

    if (!file_exists($userStateFile)) {
        continue;
    }

    $userState = json_decode(file_get_contents($userStateFile), true);
    
    // اگر نمایش ساعت فعال بود
    if (isset($userState['time_on']) && $userState['time_on'] === true) {
        $settings = [
            'logger' => [
                'logger_level' => Logger::LOGGER_LEVEL_WARNING,
            ],
            'session' => [
                'session_dir' => SESSIONS_DIR,
            ],
        ];

        // ساخت نمونه MadelineProto برای هر سشن
        $madeline = new API(SESSIONS_DIR . $userId . '.madeline', $settings);

        try {
            $madeline->async(function () use ($madeline) {
                yield $madeline->start();
                
                // دریافت زمان فعلی به وقت تهران و فرمت‌بندی آن
                $currentTime = date('H:i');
                
                // به‌روزرسانی نام خانوادگی
                yield $madeline->account->updateProfile([
                    'last_name' => $currentTime
                ]);
            });
            // اجرای حلقه‌ی رویداد
            $madeline->loop();
        } catch (\Throwable $e) {
            // در صورت بروز خطا، سشن را حذف کرده و به کاربر اطلاع می‌دهد
            @unlink($sessionFile);
            @unlink(SESSIONS_DIR . $userId . '.madeline');
            @unlink(SESSIONS_DIR . $userId . '.madeline.json');
            @unlink($userStateFile);
            echo "Error for user $userId: " . $e->getMessage() . "\n";
        }
    }
}

