<?php
// فایل set_webhook.php - برای تنظیم وب‌هوک
require_once __DIR__ . '/vendor/autoload.php';
require_once __DIR__ . '/config.php';

use danog\MadelineProto\API;
use danog\MadelineProto\Logger;

try {
    $settings = [
        'logger' => ['logger_level' => Logger::LOGGER_LEVEL_WARNING],
        'session' => ['session_dir' => SESSIONS_DIR],
    ];

    $botAPI = new API(SESSIONS_DIR . 'bot.madeline', $settings);
    
    // وب‌هوک را تنظیم و شروع می‌کند.
    $botAPI->bot->setWebhook(WEBHOOK_URL);
    $botAPI->start();
    
    echo "Webhook was set successfully to: " . WEBHOOK_URL;
} catch (\Throwable $e) {
    echo "Error setting webhook: " . $e->getMessage();
}
